// Title      : Transform.java
// Author     : James Baird
// Created    : Tuesday, 5th October 2004

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Transform
{

  public static void main(String args[])
  {
    transform(args[0], args[1]);
  }

  public static void transform(String resultsDirectory, String outfileName)
  {
    try
    {
      FileWriter outfile = new FileWriter(outfileName);

      File directory = new File(resultsDirectory);

      String[] submissions = directory.list();

      for (int i = 0; i < submissions.length; i++)
        if (submissions[i].endsWith(".txt"))
        {
          BufferedReader br = new BufferedReader(new FileReader(resultsDirectory + "/" + submissions[i]));

          Submission submission = new Submission(submissions[i]);

          String line = br.readLine();
          while (line != null)
          {
            if (line.startsWith(Submission.SELECTION1))
              submission.setSelection1(line.substring(Submission.SELECTION1.length()));

            if (line.startsWith(Submission.SELECTION2))
              submission.setSelection2(line.substring(Submission.SELECTION2.length()));

            if (line.startsWith(Submission.SELECTION3))
              submission.setSelection3(line.substring(Submission.SELECTION3.length()));

            if (line.startsWith(Submission.SELECTION4))
              submission.setSelection4(line.substring(Submission.SELECTION4.length()));

            if (line.startsWith(Submission.GENDER))
              submission.setGender(line.substring(Submission.GENDER.length()));

            if (line.startsWith(Submission.FREQUENCY))
              submission.setFrequency(line.substring(Submission.FREQUENCY.length()));

            if (line.startsWith(Submission.SOURCE))
              submission.setSource(line.substring(Submission.SOURCE.length()));


            if (line.startsWith(Submission.SCALE1))
              submission.setScale1(line.substring(Submission.SCALE1.length()));

            if (line.startsWith(Submission.SCALE2))
              submission.setScale2(line.substring(Submission.SCALE2.length()));

            if (line.startsWith(Submission.SCALE3))
              submission.setScale3(line.substring(Submission.SCALE3.length()));

            if (line.startsWith(Submission.SCALE4))
              submission.setScale4(line.substring(Submission.SCALE4.length()));


            if (line.startsWith(Submission.REASON1))
              submission.setReason1(line.substring(Submission.REASON1.length()));
            
            if (line.startsWith(Submission.REASON2))
              submission.setReason2(line.substring(Submission.REASON2.length()));

            if (line.startsWith(Submission.REASON3))
              submission.setReason3(line.substring(Submission.REASON3.length()));

            if (line.startsWith(Submission.REASON4))
              submission.setReason4(line.substring(Submission.REASON4.length()));


            if (line.startsWith(Submission.GENERALCOMMENTS))
              submission.setGeneralComments(line.substring(Submission.GENERALCOMMENTS.length()));


            line = br.readLine();
          }

          br.close();

          submission.export(outfile);
        }

      outfile.flush();
      outfile.close();
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }
  }

}

